<?php
session_start();

// Pieslēdzas datubāzei
$servername = "localhost";
$username = "root";
$password = ""; 
$dbname = "quiz_db"; 

$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbaudām savienojuma statusu
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Pārbauda, vai ir nosūtīta forma, izmantojot POST metodi

    // Pārbauda, vai ir nosūtīta pašreizējā parole
    if (!isset($_POST['current-password']) || empty($_POST['current-password'])) {
        die("Lūdzu ievadiet pašreizējo paroli.");
    }
    
    // Pārbauda, vai ir nosūtīta jaunā parole
    if (!isset($_POST['new-password']) || empty($_POST['new-password'])) {
        die("Lūdzu ievadiet jauno paroli.");
    }
    
    // Pārbauda, vai ir nosūtīta apstiprinājuma parole
    if (!isset($_POST['confirm-password']) || empty($_POST['confirm-password'])) {
        die("Lūdzu apstipriniet jauno paroli.");
    }
    
    // Pārbauda, vai jaunā parole atbilst apstiprinājuma parolei
    if ($_POST['new-password'] !== $_POST['confirm-password']) {
        die("Jaunā parole nesakrīt ar apstiprinājuma paroli.");
    }

    // Pārbauda, vai lietotāja ID ir sesijā
    if (!isset($_SESSION['user_id'])) {
        die("Lietotāja ID nav atrasts sesijā.");
    }
    
    $user_id = $_SESSION['user_id']; // Get user ID from session
    $current_password = $_POST['current-password'];

    $stmt = $conn->prepare("SELECT password FROM users WHERE id = ? LIMIT 1");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows == 1) {
        $stmt->bind_result($hashed_password);
        $stmt->fetch();

        if (password_verify($current_password, $hashed_password)) {
            // Ja pašreizējā parole ir pareiza, atjauno jauno paroli datubāzē
            $new_password = $_POST['new-password'];
            $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $update_stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            $update_stmt->bind_param("si", $new_hashed_password, $user_id);
            if ($update_stmt->execute()) {
                // Paroles veiksmīgi atjaunotas
                echo "Iestatījumi veiksmīgi saglabāti.";
                echo "<script>
                        setTimeout(function() {
                            window.location.href = '../html/sakumlapa.html';
                        }, 2000);
                      </script>";
            } else {
                echo "Kļūda atjaunojot paroli: " . $conn->error;
            }
        } else {
            // Ja pašreizējā parole nav pareiza
            die("Nepareiza pašreizējā parole.");
        }
    } else {
        // Lietotājs nav atrasts datubāzē
        die("Lietotājs nav atrasts.");
    }

    $stmt->close();
    $update_stmt->close();
} else {
    // Ja POST metode nav izmantota, novirza uz sākumlapu
    header("Location: ../html/iestatijumi.html");
    exit();
}

$conn->close();
?>
